
IF  EXISTS (SELECT *
FROM sys.views
WHERE object_id = OBJECT_ID(N'[dbo].[V_WEB_LIST_DEMISSOES]'))
	BEGIN
    DROP VIEW [dbo].[V_WEB_LIST_DEMISSOES]
END
GO

CREATE VIEW [dbo].[V_WEB_LIST_DEMISSOES]
AS
                    SELECT
            A.CD_EMP
		, A.CD_CONV_DEMITE
		, A.DT_CAD
		, A.DT_DISP
		, COUNT(B.CD_CLI) AS QDE
		, E.RZ_CLI AS SOLICITANTE
		, 'CONVENIO' AS ORIGEM
		, A.CD_CONV
        FROM
            dbo.WEB_CONV_DEMITE AS A
            INNER JOIN dbo.WEB_CONV_DEMITE_RC_CLI AS B
            ON A.CD_CONV_DEMITE = B.CD_CONV_DEMITE
            INNER JOIN dbo.WEB_CONV_DEMITE_WEB_CONV_USU_RC_CLI_CONV_RC_CLI AS C
            ON B.CD_CONV_DEMITE = C.CD_CONV_DEMITE
                AND B.CD_EMP = C.CD_EMP
            INNER JOIN dbo.WEB_CONV_USU_RC_CLI_CONV_RC_CLI AS D
            ON C.CD_EMP = D.CD_EMP
                AND C.CD_USU_MOV = D.CD_USU_CONV
            INNER JOIN dbo.RC_CLI AS E
            ON D.CD_EMP = E.CD_EMP
                AND D.CD_CLI = E.CD_CLI
        GROUP BY A.CD_EMP
		    ,A.CD_CONV_DEMITE
		  , A.DT_CAD
		  , A.DT_DISP
		  , E.RZ_CLI
		  , A.CD_CONV

    UNION
        SELECT
            A.CD_EMP
		, A.CD_CONV_DEMITE
		, A.DT_CAD
		, A.DT_DISP
		, COUNT(B.CD_CLI) AS QDE
		, E.RZ_CLI AS SOLICITANTE
		, 'CONVENIO' AS ORIGEM
		, A.CD_CONV
        FROM
            dbo.WEB_CONV_DEMITE AS A
            INNER JOIN dbo.WEB_CONV_DEMITE_RC_CLI AS B
            ON A.CD_CONV_DEMITE = B.CD_CONV_DEMITE
            INNER JOIN dbo.RC_CLI AS E
            ON A.CD_EMP = E.CD_EMP
                AND A.CD_CLI = E.CD_CLI
        GROUP BY A.CD_EMP
		    ,A.CD_CONV_DEMITE
		  , A.DT_CAD
		  , A.DT_DISP
		  , E.RZ_CLI
		  , A.CD_CONV

    UNION
        SELECT
            A.CD_EMP
		, A.CD_CONV_DEMITE
		, A.DT_CAD
		, A.DT_DISP
		, COUNT(B.CD_CLI) AS QDE
		, E.NM_USU AS SOLICITANTE
		, 'REDE DROGARIA' AS ORIGEM
		, A.CD_CONV
        FROM
            dbo.WEB_CONV_DEMITE AS A
            INNER JOIN dbo.WEB_CONV_DEMITE_RC_CLI AS B
            ON A.CD_CONV_DEMITE = B.CD_CONV_DEMITE
            INNER JOIN dbo.WEB_CONV_DEMITE_WEB_CONV_USU_GLB_USU AS C
            ON A.CD_CONV_DEMITE = C.CD_CONV_DEMITE
            INNER JOIN dbo.GLB_USU AS E
            ON C.CD_USU = E.CD_USU
        GROUP BY A.CD_EMP
		    ,A.CD_CONV_DEMITE
		  , A.DT_CAD
		  , A.DT_DISP
		  , E.NM_USU
		  , A.CD_CONV
		  , C.CD_USU
    UNION
        SELECT
            A.CD_EMP
		, A.CD_CONV_DEMITE
		, A.DT_CAD
		, A.DT_DISP
		, COUNT(B.CD_CLI) AS QDE
		, E.NM_USU AS SOLICITANTE
		, 'REDE DROGARIA' AS ORIGEM
		, A.CD_CONV
        FROM
            dbo.WEB_CONV_DEMITE AS A
            INNER JOIN dbo.WEB_CONV_DEMITE_RC_CLI AS B
            ON A.CD_CONV_DEMITE = B.CD_CONV_DEMITE
            INNER JOIN dbo.GLB_USU AS E
            ON A.CD_USU = E.CD_USU
        GROUP BY A.CD_EMP
		    ,A.CD_CONV_DEMITE
		  , A.DT_CAD
		  , A.DT_DISP
		  , E.NM_USU
		  , A.CD_CONV
		  , A.CD_USU;
